#include <iostream>
#include <chrono>
#include <cmath>

int ceil_sqrt(int n) {
    if (n < 0) return -1;
    int sqrt_floor = static_cast<int>(std::sqrt(n));
    if (sqrt_floor * sqrt_floor == n) {
        return sqrt_floor;
    }
    else {
        return sqrt_floor + 1;
    }
}

int main() {
    int number;
    std::cin >> number;
    int sqrt = ceil_sqrt(number);
    auto start = std::chrono::high_resolution_clock::now();
    if(number < 4) {
        std::cout << "yes" << std::endl;
        return 0;
    }
    for (int del = 2; del <= sqrt; del++) {
        if (number % del == 0) {
            std::cout << "no" << std::endl;
            return 0;
        }
    }
    std::cout << "yes" << std::endl;
    return 0;
}
